var Mouse = {};
Mouse.image = LoadImage("testmoust.png"); // change this with your own image
Mouse.x = GetMouseX();
Mouse.y = GetMouseY();
Mouse.leftIdle = true;
Mouse.rightIdle = true;
 
Mouse.updateAndDraw = function()
{
  this.x = GetMouseX();
  this.y = GetMouseY();
  this.image.blit(this.x, this.y);
}
 
Mouse.leftClick = function()
{
  // this if conditional tells Sphere that you can click only once
  if (IsMouseButtonPressed(MOUSE_LEFT) && this.leftIdle)
  {
    this.leftIdle = false;
    return true;
  }
  return false;
}
 
Mouse.rightClick = function()
{
  if (IsMouseButtonPressed(MOUSE_RIGHT) && this.rightIdle)
  {
    this.rightIdle = false;
    return true;
  }
  return false;
}
 
Mouse.updateMouseState = function()
{
  // these if conditionals tell sphere it's okay to click again.
  if (!IsMouseButtonPressed(MOUSE_LEFT)) this.leftIdle = true;
  if (!IsMouseButtonPressed(MOUSE_RIGHT)) this.rightIdle = true;
}

function Menu(x, y, w, h, font, window_style)
{
  this.x = x;
  this.y = y;
  this.w = w;
  this.h = h;
 
  // the "||" make it so you don't need a font or window; Sphere will assume the latter.
  this.font = font || GetSystemFont();
  this.font_height = this.font.getHeight();
  this.window_style = window_style || GetSystemWindowStyle();
 
  this.items = [];
  this.selection = 0;
}
 
Menu.prototype.addItem = function(name, callback, color, color_on)
{
  var item = {};
  item.name = name;
  item.color = color || CreateColor(255, 255, 255);
  item.color_on = color_on || CreateColor(255, 0, 0);
  item.callback = callback;
 
  this.items.push(new item);
}
 
Menu.prototype.execute = function()
{
  var done = false;
  while(!done)
  {
    this.window_style.drawWindow(this.x, this.y, this.w, this.h);
 
    for (var i = 0; i < this.items.length; ++i)
    {
      // we change item eslection color here : //
      if (i == this.selection) this.font.setColorMask(this.items[i].color_on);
      else this.font.setColorMask(this.items[i].color);
 
      this.font.drawText(this.x, this.y + i * this.font_height, this.items[i].name);
 
      // we add mouse support here : //
      if (Mouse.x > this.x && Mouse.x < this.x + this.w &&
          Mouse.y > this.y + i * this.font_height &&
          Mouse.y < this.y + i * this.font_height + this.font_height)
      {
        this.selection = i;
 
        // here we add mouse clicking support : //
        if (Mouse.leftClick())
        {
          done = true;
          this.items[this.selection].callback();
        }
      }
    }
 
    this.mouse.updateMouseState();
    FlipScreen();
  }
}